import { getServerSession } from 'next-auth';
import { authOptions } from '@/app/api/auth/[...nextauth]/route';
import { redirect } from 'next/navigation';

export default async function AnnonceDetail() {
    const session = await getServerSession(authOptions);

    if (!session) {
        redirect('/');
    }

    return (
        <div>
            <h1>Détails de l'annonce</h1>
            <p>Bienvenue, {session.user?.firstName} !</p>
            <p>Votre ID est : {session.user?.id}</p>
        </div>
    );
}